
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:17:37 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_ECC_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/*****************************************************************************
 * File Name:                                                           
 *  CRYS_ATP_TST_ECC_Acceptance_test_vectors.c      
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for RCA Acceptance tests                              
 *
 ******************************************************************************/

/************* Include Files ****************/
#include "CRYS_error.h"
#include "CRYS_ATP_TST_ECC_Acceptance.h"
#if TST_USE_ECC_DATA/*In case no test vectors are selected - code disabled*/
/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
/************* Private function prototype **************************/
/************************ Public Functions *************************/
/************************ Private Functions ************************/

/********************************/
/*  ECDSA SignVerify test data  */
/********************************/

#if !(TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_48BYTE_DATA|TST_USE_ECC_64BYTE_DATA|TST_USE_ECC_128BYTE_DATA|TST_USE_ECC_256BYTE_DATA|TST_USE_ECC_512BYTE_DATA)
TST_ECC_SignVerifyTestDataStruct TST_ECC_Acceptance_ECDSA_SignVerify_TestData[] = {0};
#else
TST_ECC_SignVerifyTestDataStruct TST_ECC_Acceptance_ECDSA_SignVerify_TestData[] =
{
    #if TST_USE_ECC_23BYTE_DATA
	{ 
        {"Acceptance test - ECDSA_SignVerify WMDRM-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_WMDRM10,
		/*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,       
		/*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
		0xe3,0xd9,0x85},
        /*TST_input_dataSize*/
        19, 
         /*TST_ExternalPublKey*/
        {0x36,0x41,0x4F,0xE7,0xDD,0x87,0x39,0x84,0x30,0x13,0x99,0xF4,0x83,0xD6,0xA1,0x79,0xE0,0xD2,0x2C,0xED,0x6D, 
		0x2D,0xB,0x5A,0x23,0x81,0x36,0xD5,0xCD,0x58,0x15,0x26,0x4F,0x8D,0xCA,0x8,0x40,0x92,0x80,0x33},
        /*TST_ExternalPublKeySize*/
        40,
        /*TST_ExternalPrivKey*/
        {0x63,0x8D,0x7E,0xAC,0x1A,0x10,0x9D,0x7,0x47,0x8D,0x8C,0xB8,0xE6,0x69,0x8,0x5E,0x94,0x52,0xA0,0x4b},
        /*TST_ExternalPrivlKeySize*/
        20,
		/*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        42,
	},
    #endif
    #if TST_USE_ECC_48BYTE_DATA
	{
		  {"Acceptance test - ECDSA_SignVerify - secp160r1-Key - 48byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp160r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
         /*TST_input_dataSize*/
         48, 
         /*TST_ExternalPublKey*/
        {0x4,0x95,0x4F,0x60,0x20,0x11,0x30,0xF0,0xE3,0x14,0x23,0x88,0x84,0x79,0x53,0x88,0x6C,0x37,0x7A,0x50,0x4C, 
		0x5B,0x2D,0x2A,0xF3,0x85,0xC7,0xF1,0x4B,0xA1,0x6D,0xF3,0xAA,0xFE,0xA,0x11,0x32,0x4D,0x7A,0x6E,0x0},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x27,0x97,0x7D,0xFB,0x77,0x21,0xED,0xBF,0x24,0x33,0x7A,0x7E,0xC4,0x1F,0xF7,0xBD,0xB0,0xA3,0xA1,0xd4},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        42,
      },
	  { 
        {"Acceptance test - ECDSA_SignVerify - secp160r2-Key - 48byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp160r2,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
         /*TST_input_dataSize*/
         48, 
         /*TST_ExternalPublKey*/
        {0x4,0x52,0xCB,0x7,0xF4,0x84,0xF9,0xAE,0xCE,0x38,0x31,0xCB,0xC8,0xD3,0xF0,0x4E,0xD,0x4E,0x75,0xD2,0x34, 
		0xC5,0xA2,0x83,0x21,0x41,0x5D,0x23,0x79,0x9B,0x1E,0xB2,0xCA,0x7F,0x57,0x45,0x60,0xDC,0xDC,0x70,0x89},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x54,0x66,0x51,0x66,0x4C,0xDC,0xE6,0xC6,0xE4,0xE9,0x56,0x3,0xD3,0x62,0xD0,0x89,0x1A,0x85,0xF1,0x5},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        42,
      }, { 
        {"Acceptance test - ECDSA_SignVerify - secp160k1-Key - 48byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp160k1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
         /*TST_input_dataSize*/
         48, 
         /*TST_ExternalPublKey*/
        {0x4,0x88,0x5,0x4E,0xA4,0x8,0xDF,0xB,0x5F,0x51,0x5,0x38,0x22,0x4B,0xBA,0x36,0xED,0x53,0x15,0x97,0x5F, 
		0xE0,0xDD,0x3E,0xE9,0xF6,0xDA,0x26,0xD5,0xF2,0xF3,0x19,0xBF,0xF4,0xE1,0x6D,0x93,0xC1,0x1D,0xF,0xa8},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
		{0x8B,0x4B,0xA3,0xCC,0x6,0x57,0xDA,0x99,0x12,0x94,0xF5,0x98,0x85,0x3D,0xC4,0x25,0xD2,0xD1,0xC7,0x3b},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        42,
      },
	  { 
        {"Acceptance test - ECDSA_SignVerify - secp192r1 -Key - 48byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp192r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
         /*TST_input_dataSize*/
         48, 
         /*TST_ExternalPublKey*/
        {0x04,
         0x43,0x96,0x40,0x72,0x1a,0x66,0x7c,0xe0,0xa7,0x99,0xbe,0xa3,0x21,0x1a,0xdf,0x7b,
         0xfb,0xe9,0x66,0x23,0xa4,0xbe,0x45,0x90,0x6c,0x57,0x16,0x92,0xa2,0xa7,0x67,0x87,
         0xd9,0x57,0xee,0x3f,0x0c,0x81,0x33,0x33,0x99,0xd7,0xd3,0xd4,0x5f,0xa1,0x61,0x19},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9},
        /*TST_ExternalPrivlKeySize*/
        24,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        48,
     },
	 { 
        {"Acceptance test - ECDSA_SignVerify - secp192k1 -Key - 48byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp192k1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e},
         /*TST_input_dataSize*/
         48, 
         /*TST_ExternalPublKey*/
        {0x4,0x9B,0x3C,0xF6,0xC7,0xDD,0x70,0x6D,0xA9,0xCE,0x4B, 
		0x44,0x56,0xD4,0xAF,0xF1,0x5,0x87,0xEB,0x1C,0xA4,0x3F,0xB5,0xB5,0xCD,0x6A,0x13,0x1B,0xCD,0x18,0x19, 
		0x3E,0x24,0x4D,0x13,0xAC,0xAA,0x40,0xFC,0xA6,0x45,0x58,0x20,0xAD,0xA6,0x6,0x64,0x4F,0x59},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0x17,0x12,0x10,0xB3,0x5B,0xC4,0x6D,0xF,0x3D,0xBA,0x5B,0x69,0x2C,0xAE,0xA6,0x68,0xE9,0xF8,0x20,0x8,0x84,0x26,0x28,0x67},
        /*TST_ExternalPrivlKeySize*/
        24,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        48,
    },
    #endif
    #if TST_USE_ECC_64BYTE_DATA
    {
        {"Acceptance test - ECDSA_SignVerify - secp224r1 -Key - 64byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp224r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x0c,0xa6,0x3e,0x72,0x50,0xfc,0x16,0x9d,0xf5,0xd2,0x7e,0xe3,0xe4,0x01,0x3c,0x06,
         0xa7,0x79,0xd2,0x8e,0x71,0x32,0xa2,0x63,0x5e,0x66,0x56,0x9b,0xfb,0xfe,0x7f,0x91,
         0x09,0x4a,0x7c,0x37,0x7e,0xf4,0x9e,0xad,0xcd,0x37,0x8a,0x12,0x67,0x4c,0xde,0x9a,
         0x82,0x25,0x17,0xe0,0x19,0x5e,0xb2,0x7e,0x34,0x71,0x91,0xdc,0x69,0x29,0xa1,0x45},
         /*TST_input_dataSize*/
         64, 
         /*TST_ExternalPublKey*/
        {0x04,
         0x40,0x87,0xa4,0x1a,0x7c,0x75,0xee,0x5e,0x4f,0xcd,0x7a,0xe2,0x40,0x85,0x41,0xab,
         0xaf,0x65,0x01,0xe6,0x9d,0xfb,0x2f,0xaf,0x2b,0x91,0x74,0xa4,0x5a,0x61,0x4b,0x6e,
         0x94,0xdd,0x9f,0x09,0x7c,0x6f,0x79,0x80,0x3c,0x06,0x28,0x52,0x6a,0xe1,0xd8,0x00,
         0x42,0x02,0x90,0xef,0xd5,0x17,0x24,0xa4},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f},
        /*TST_ExternalPrivlKeySize*/
        28,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        56,
    },  
	{
        {"Acceptance test - ECDSA_SignVerify - secp224k1 -Key - 64byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp224k1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x0c,0xa6,0x3e,0x72,0x50,0xfc,0x16,0x9d,0xf5,0xd2,0x7e,0xe3,0xe4,0x01,0x3c,0x06,
         0xa7,0x79,0xd2,0x8e,0x71,0x32,0xa2,0x63,0x5e,0x66,0x56,0x9b,0xfb,0xfe,0x7f,0x91,
         0x09,0x4a,0x7c,0x37,0x7e,0xf4,0x9e,0xad,0xcd,0x37,0x8a,0x12,0x67,0x4c,0xde,0x9a,
         0x82,0x25,0x17,0xe0,0x19,0x5e,0xb2,0x7e,0x34,0x71,0x91,0xdc,0x69,0x29,0xa1,0x45},
         /*TST_input_dataSize*/
         64, 
         /*TST_ExternalPublKey*/
        {0x4,0xCC,0xCB,0x75,0xC7,0x91,0x5F,0x2B,0x7E,0x81,0xF4,0xB9,0x18,0x10,0x47,0xB2,0x89,0x7,0x9E,0x3B,0x43, 
		0x19,0xE4,0xAB,0x83,0x4D,0x2E,0xDE,0x53,0x12,0xD4,0xC2,0x53,0xEF,0x93,0x1A,0xEC,0xF4,0x94,0x5B,0x1, 
		0x5D,0x90,0x2F,0x5E,0xE2,0x2F,0xAD,0x51,0xA9,0xCE,0x9E,0x98,0x80,0x32,0x18,0x5f},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0x64,0x12,0x78,0x2A,0xF3,0x8F,0xEB,0xEA,0x11,0x81,0xC, 
		0xA4,0xF1,0x6F,0x7D,0x21,0xE6,0x1B,0x7B,0x48,0x8F, 
		0xE0,0x84,0xF9,0x95,0x3B,0x32,0xa},
        /*TST_ExternalPrivlKeySize*/
        28,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        58,
    },
    #endif
    #if TST_USE_ECC_128BYTE_DATA
	{
        {"Acceptance test - ECDSA_SignVerify - secp256r1-Key - 128byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp256r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0xd4,0xcd,0xa5,0x8a,0x83,0xcd,0xbb,0x42,0xac,0x9f,0xa5,0xa2,0x6e,0xee,0x31,0xd1,
         0xa7,0x3a,0xb1,0x6b,0xcd,0x2a,0xfc,0x79,0x19,0x23,0xb5,0xa0,0xeb,0x19,0xd0,0x98,
         0x6a,0xa5,0x51,0xe0,0x6a,0x58,0x57,0xb0,0x94,0x50,0x5a,0x30,0xc0,0x08,0xb1,0xe7,
         0xa6,0x74,0x57,0x76,0xb6,0x4e,0xee,0x86,0x44,0xab,0x04,0xff,0xe8,0xd1,0x96,0x7a,
         0x25,0x4c,0xd2,0xfa,0x48,0x3f,0x21,0xd6,0x93,0xf9,0x65,0xfa,0x9b,0xc8,0x7f,0x50,
         0xef,0x12,0x15,0x78,0xfa,0xa1,0x92,0xbf,0x2b,0x3f,0x6e,0x4f,0x53,0x83,0xaf,0xa3,
         0x4e,0xea,0xb0,0x3e,0xe5,0x29,0x21,0x9d,0xf3,0xc2,0x4f,0x6a,0xc7,0xd6,0xa5,0xf2,
         0xca,0x3a,0x73,0xd9,0x61,0xcd,0xef,0x0c,0x15,0x08,0x7a,0xf8,0xf2,0xd6,0x24,0xfa},
         /*TST_input_dataSize*/
         128, 
         /*TST_ExternalPublKey*/
        {0x04,
         0x2a,0xe4,0xa3,0xca,0x17,0x5e,0x29,0x90,0xfa,0x1e,0x8b,0x67,0x7d,0x33,0x6b,0x4c,
         0xbc,0xe2,0xd8,0x53,0xd7,0x0f,0x37,0x81,0x86,0xe4,0x5b,0x39,0x0b,0x52,0x3d,0xa7,
         0x09,0xaf,0x5b,0xa5,0x62,0x5e,0x73,0xed,0x88,0x3b,0xe1,0xe7,0xac,0x48,0x30,0x06,
         0xa7,0x0f,0x66,0xad,0xf3,0x1f,0xbb,0xe5,0x89,0x1b,0x4b,0x0d,0xa4,0x6c,0xaa,0x07},
        /*TST_ExternalPublKeySize*/
        65,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38},
        /*TST_ExternalPrivlKeySize*/
        32,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        64,
    },
    {
        {"Acceptance test - ECDSA_SignVerify - secp256k1-Key - 128byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp256k1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0xd4,0xcd,0xa5,0x8a,0x83,0xcd,0xbb,0x42,0xac,0x9f,0xa5,0xa2,0x6e,0xee,0x31,0xd1,
         0xa7,0x3a,0xb1,0x6b,0xcd,0x2a,0xfc,0x79,0x19,0x23,0xb5,0xa0,0xeb,0x19,0xd0,0x98,
         0x6a,0xa5,0x51,0xe0,0x6a,0x58,0x57,0xb0,0x94,0x50,0x5a,0x30,0xc0,0x08,0xb1,0xe7,
         0xa6,0x74,0x57,0x76,0xb6,0x4e,0xee,0x86,0x44,0xab,0x04,0xff,0xe8,0xd1,0x96,0x7a,
         0x25,0x4c,0xd2,0xfa,0x48,0x3f,0x21,0xd6,0x93,0xf9,0x65,0xfa,0x9b,0xc8,0x7f,0x50,
         0xef,0x12,0x15,0x78,0xfa,0xa1,0x92,0xbf,0x2b,0x3f,0x6e,0x4f,0x53,0x83,0xaf,0xa3,
         0x4e,0xea,0xb0,0x3e,0xe5,0x29,0x21,0x9d,0xf3,0xc2,0x4f,0x6a,0xc7,0xd6,0xa5,0xf2,
         0xca,0x3a,0x73,0xd9,0x61,0xcd,0xef,0x0c,0x15,0x08,0x7a,0xf8,0xf2,0xd6,0x24,0xfa},
         /*TST_input_dataSize*/
         128, 
         /*TST_ExternalPublKey*/
        {0x4,0xBF,0xC2,0x4C,0xCD,0x8B,0x2E,0x52,0x10,0x36,0x64,0x85,0x3,0x66,0x98,0x2B,0xC4,0x47,0xEC,0x49,0x68, 
		0x4C,0x26,0xB9,0x20,0xF6,0xB,0x20,0xE2,0xF4,0xF2,0x4B,0x7F,0x28,0x5D,0x74,0x81,0xA3,0xD1,0x6B,0x16, 
		0x87,0xF3,0xEE,0x21,0x90,0xF,0x3C,0x96,0xE0,0x53,0x21,0x83,0x94,0x0,0xE8,0x96,0x45,0x4F,0x47,0xF4,0xD8,0xA1,0xD9,0xae},
        /*TST_ExternalPublKeySize*/
        65,
        /*TST_ExternalPrivKey*/
        {0xB5,0xCD,0x5E,0xB3,0x93,0xA5,0xB8,0x69,0xDE,0xCA,0xF8,0x8D,0x56,0x20,0x85,0xB1,0x7E,0xED,0x74,0xB1,0x94, 
		 0x79,0x16,0xDA,0x93,0xFE,0x82,0x53,0x90,0x4,0x93,0xa7},
        /*TST_ExternalPrivlKeySize*/
        32,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        64,
    },
    #endif
    #if TST_USE_ECC_256BYTE_DATA
    {
        {"Acceptance test - ECDSA_SignVerify - secp384r-Key - 256byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp384r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0x28,0xf0,0x82,0x3f,0x1b,0xfe,0xe5,0xac,0x51,0x25,0x4e,0x15,0x6c,0x14,0x02,0xb8,
         0x80,0x1e,0x55,0xad,0x17,0x32,0xcb,0x78,0x79,0x0d,0x7c,0xdb,0x2a,0xae,0xbd,0xee,
         0xb3,0x0a,0xfc,0x71,0xa5,0x02,0xec,0x60,0xdc,0x92,0xe3,0xc8,0x01,0x4b,0x80,0xda,
         0x52,0x03,0x90,0x3d,0xa6,0xcb,0x32,0xa9,0xab,0x21,0x3a,0xb2,0x73,0x67,0xd4,0xe1,
         0x2f,0x94,0x6a,0x09,0x3a,0x2a,0xc7,0xd8,0x59,0x68,0x7c,0xad,0x41,0xc0,0x82,0xa9,
         0x59,0x8b,0x22,0x09,0xc2,0xfc,0x12,0xb3,0x95,0x52,0xe1,0x0e,0x6b,0x52,0x94,0x17,
         0x23,0xf5,0x92,0xb2,0xdf,0x5e,0xbd,0x3d,0x50,0x0e,0xe2,0x6b,0x34,0x5b,0x53,0x50,
         0x1c,0x1e,0xd2,0xb8,0x73,0xad,0xb1,0xbd,0xbc,0x09,0x38,0x99,0x1b,0x58,0x47,0xb8,
         0x17,0x95,0x3c,0x12,0x9e,0x86,0x17,0xb7,0x49,0xee,0xdd,0xab,0xe2,0x05,0x3a,0xf5,
         0x24,0x25,0x69,0xf3,0xc1,0xc6,0x59,0xf0,0xaa,0xac,0x08,0xf8,0x8a,0x5f,0x33,0xeb,
         0x93,0xdc,0x32,0xd1,0x7e,0x8a,0x1e,0x6d,0xcd,0x6f,0x34,0x15,0x54,0xa4,0x7e,0xc1,
         0xf7,0x06,0xb0,0x61,0xb5,0x2f,0x50,0x74,0xe6,0xa5,0x19,0xd6,0xc0,0x50,0xa2,0xd9,
         0x20,0x32,0x3b,0x98,0x88,0x52,0x17,0x88,0x63,0xf9,0xb1,0x50,0x91,0x21,0x68,0xdb,
         0x1f,0x2b,0x6c,0xab,0x56,0xd0,0xde,0x70,0xf8,0x5a,0x33,0xd9,0xc6,0x14,0xda,0xaa,
         0x45,0xff,0x1e,0x0f,0xc2,0xc6,0x4d,0x2f,0x94,0xf4,0x1a,0x05,0xa1,0x65,0x40,0x6b,
         0x24,0xfa,0x68,0x78,0xad,0x91,0x4d,0x0c,0x69,0x35,0x1e,0xa9,0xa3,0x91,0x24,0x85},
         /*TST_input_dataSize*/
         256, 
         /*TST_ExternalPublKey*/
        {0x04,
         0xb9,0x58,0x84,0xa3,0x9a,0x35,0x04,0xae,0x26,0x61,0x97,0xef,0xb5,0xc4,0x9b,0x5d,
         0x56,0xf0,0xe5,0xba,0xd7,0xb2,0xae,0x42,0xfd,0xb0,0x28,0x35,0x62,0x0f,0xec,0xd4,
         0xa3,0x1e,0xcd,0xf0,0x11,0x6f,0x0b,0x2e,0x7d,0x6a,0x28,0xab,0x3e,0x43,0x5e,0xa6,
         0x15,0xb9,0x7b,0xe5,0xaa,0xa7,0x75,0xb5,0x21,0x1c,0xc9,0x48,0x4c,0xd2,0x23,0x28,
         0xe6,0xb7,0x52,0x67,0xfd,0xb1,0x31,0x94,0x61,0x05,0xbe,0xb3,0x71,0xfc,0x41,0x64,
         0xd6,0xad,0xa9,0xba,0xff,0x8f,0xc0,0x15,0x8e,0xe6,0x50,0xb7,0xfe,0x9f,0x74,0x71},
        /*TST_ExternalPublKeySize*/
        97,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38,
         0x77,0x75,0xfd,0xb4,0x4c,0xf5,0xb8,0x52,0x7b,0x1f,0x85,0x13,0xc6,0x78,0xae,0xa7},
        /*TST_ExternalPrivlKeySize*/
        48,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        96,
    },
    #endif
    #if TST_USE_ECC_512BYTE_DATA
    {
        {"Acceptance test - ECDSA_SignVerify - secp521r-Key - 512byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp521r1,
         /*CRYS_ECPKI_HASH_OpMode_t*/
         CRYS_ECPKI_HASH_SHA1_mode,
         /*TST_input_data*/
        {0xf4,0xd0,0x05,0x79,0x91,0xdd,0x6e,0xca,0x3c,0x42,0x50,0x38,0xf7,0x47,0xdd,0x00,
         0x97,0xc0,0xa8,0x35,0x74,0xf0,0xfe,0xc0,0x65,0xa8,0x7a,0xa6,0xec,0xaf,0xd4,0x89,
         0xad,0x66,0xfa,0x72,0x25,0xac,0x62,0xcd,0x98,0x00,0x9e,0xb5,0x4b,0xe5,0x31,0x72,
         0xf4,0x8b,0xa1,0x40,0x6f,0xab,0xcd,0x52,0xb2,0xb3,0x81,0x17,0x03,0x23,0x48,0xbc,
         0x69,0x37,0x81,0xf2,0x60,0xc6,0xb5,0xf1,0xd0,0x6a,0x28,0xbd,0x40,0xe1,0xae,0xa8,
         0x47,0xb3,0xc0,0x18,0x44,0x15,0xcf,0x8a,0x4f,0x0e,0xd8,0xd7,0x70,0xd8,0x39,0xb6,
         0x0e,0x89,0xc3,0x83,0xaa,0xf3,0x10,0x3f,0xcd,0xc8,0x17,0xd7,0x3e,0x02,0xfd,0xa9,
         0x79,0x81,0x2f,0x44,0x5d,0xf6,0xad,0x6f,0x25,0x01,0xa9,0x6e,0x99,0x96,0x50,0x80,
         0x85,0xa5,0xe8,0xac,0x6b,0xfa,0x1b,0xbd,0x75,0x62,0x92,0x8c,0xad,0x0f,0xc6,0x7d,
         0x70,0x3d,0x13,0x4c,0x20,0x16,0x0f,0x0a,0x1a,0xd3,0x19,0x62,0xe8,0x25,0x35,0x21,
         0xb7,0xd3,0x17,0xf6,0x0b,0xa4,0x7d,0x75,0xb1,0x7f,0xc2,0x62,0xf6,0xd1,0xb0,0x2d,
         0x16,0x2f,0x97,0xb9,0xf7,0x3d,0x9b,0x61,0x17,0xce,0x52,0x3d,0xc3,0x4c,0x8f,0xa1,
         0x8b,0x5b,0x78,0xe7,0xf2,0xb9,0xdf,0x6f,0x6a,0x68,0xcf,0xe3,0x7f,0x10,0x64,0xc0,
         0x52,0x9f,0xe0,0x12,0x49,0x32,0xfc,0x7f,0x05,0x38,0x7c,0x86,0x94,0xd4,0x06,0x09,
         0xe8,0x84,0x34,0x09,0x88,0x01,0xe8,0xb2,0x86,0x66,0xe0,0x97,0xb1,0x93,0x8a,0x3e,
         0x0b,0xd4,0x19,0xdf,0x7e,0xbe,0xd8,0x69,0xca,0x5a,0xbe,0xc6,0xc2,0x86,0x43,0x60,
         0xb8,0x97,0x73,0xe4,0x36,0x43,0x41,0x46,0xef,0xbf,0x1d,0x05,0xf4,0x24,0xc9,0xb0,
         0x2b,0x17,0x68,0xa9,0xfe,0xa9,0xd8,0x29,0x50,0x7c,0x41,0x84,0xb5,0x28,0xee,0xae,
         0xe2,0xdc,0x5c,0xfe,0x62,0x49,0x91,0x33,0x8b,0xbb,0xaf,0xb5,0xb1,0x89,0xc9,0x1d,
         0x99,0xb0,0xf5,0xf6,0x30,0xbb,0xa3,0xc5,0x7d,0xe6,0x2d,0x48,0xd5,0x82,0xaf,0xfc,
         0x4e,0x9b,0x18,0xe1,0x76,0xd9,0x81,0x81,0x44,0xa4,0xbe,0x2f,0x4e,0x8b,0x33,0x8d,
         0x3d,0xe7,0xe9,0x51,0x7e,0xbb,0xe2,0x48,0x3b,0xdf,0xa9,0x9b,0x8a,0x5e,0x2c,0x51,
         0xe4,0x1c,0xce,0x15,0xd8,0xbc,0xb9,0x39,0x00,0xc0,0x71,0xfc,0x35,0xf2,0xaf,0x08,
         0xff,0x03,0x6c,0x3f,0x4f,0x73,0x3c,0xb7,0x71,0xb0,0xdd,0x03,0x3c,0x82,0x10,0xb5,
         0x8c,0xa6,0xa7,0x20,0xf2,0xba,0xe0,0x63,0xa9,0x59,0xf1,0xa3,0xcc,0x86,0xe4,0x97,
         0xc7,0x4e,0xa5,0x4a,0x0c,0xa9,0x5a,0x1c,0x07,0xa2,0xf2,0x0a,0x53,0xb7,0x01,0x30,
         0x2e,0x83,0xcb,0x8c,0x2a,0x9a,0x9e,0x05,0x26,0xb5,0x66,0xac,0x7d,0x0f,0x7b,0x41,
         0x7d,0x0e,0xbd,0xf9,0x1b,0x26,0xe3,0x7e,0xe4,0xfb,0x10,0x38,0x37,0xc5,0xa7,0xcb,
         0xb2,0xf9,0x61,0xe1,0xea,0x26,0x9d,0x29,0x5f,0x1c,0xf7,0xa0,0xaf,0x54,0x1b,0x0f,
         0x09,0x8c,0xdc,0xd4,0xe5,0xb2,0x80,0xe6,0xf2,0x03,0x5e,0x14,0x50,0x74,0xac,0x8d,
         0x00,0x51,0x92,0xa5,0x99,0x24,0x82,0xd6,0x3c,0xd8,0xcc,0x05,0xc9,0x1e,0x6d,0x07,
         0x53,0x10,0x28,0x64,0xd2,0x14,0xd9,0x5b,0x18,0x04,0x05,0x26,0x07,0x8c,0xb5,0x7f},
         /*TST_input_dataSize*/
         512, 
         /*TST_ExternalPublKey*/
        {0x04,
         0x00,0xa5,0x1b,0x2f,0x69,0x01,0xd0,0xbc,0xf3,0x31,0xc3,0x6b,0xfe,0xd2,0x1c,0x10,
         0x0e,0x06,0x65,0x4c,0xfe,0xeb,0x79,0x26,0x32,0x27,0xae,0x52,0x7c,0x0f,0x2d,0x5e,
         0x61,0x63,0xde,0x43,0x11,0xdd,0xae,0x04,0xb8,0xa3,0x8b,0x86,0x02,0x49,0x6a,0xa5,
         0xa0,0x29,0x3a,0x39,0xd5,0xd1,0xd9,0x66,0xe4,0xd9,0xcc,0x1b,0xc7,0x72,0xa1,0x85,
         0xd1,0x1e,0x00,0x7c,0x58,0x83,0x1b,0x20,0xb6,0xdc,0xd4,0xed,0x7d,0x5c,0x57,0x02,
         0xaa,0x48,0xb2,0xd4,0xf8,0x8c,0x22,0xdf,0x66,0xe4,0x21,0x92,0x45,0x7c,0xe5,0x77,
         0x04,0x26,0xb8,0xf1,0x49,0xa4,0x03,0x23,0x7c,0xe5,0xd7,0x4e,0xbf,0xc4,0x8b,0xee,
         0xd0,0xfa,0xba,0xf3,0x02,0xb8,0xb8,0x33,0x80,0x70,0x37,0xa0,0xfb,0x7b,0xd9,0x19,
         0x4d,0xfd,0xc9,0xd0},
        /*TST_ExternalPublKeySize*/
        133,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,0x2a,
         0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,0x38,
         0x77,0x75,0xfd,0xb4,0x4c,0xf5,0xb8,0x52,0x7b,0x1f,0x85,0x13,0xc6,0x78,0xae,0xa7,
         0x6f,0x1a,0xd4,0x08,0xdc,0xa2,0xbb,0x9a,0x02,0x78,0x34,0xd4,0x54,0x21,0x03,0x30,
         0x71},
        /*TST_ExternalPrivlKeySize*/
        65,
        /*TST_output_signiture*/
        {0},
        /*TST_SignitureSize*/
        132,
    },
    #endif
};
#endif

/**********************/
/*  ECC DH test data  */
/**********************/

TST_ECC_DH_TestDataStruct  TST_ECC_Acceptance_DH_TestData[] =
{
    { 
       {"Acceptance test - ECC-DH WMDRM-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_WMDRM10,      
      
         /*TST_ExternalPublKey*/
        {0x36,0x41,0x4F,0xE7,0xDD,0x87,0x39,0x84,0x30,0x13,0x99,0xF4,0x83,0xD6,0xA1,0x79,0xE0,0xD2,0x2C,0xED,0x6D, 
		 0x2D,0xB,0x5A,0x23,0x81,0x36,0xD5,0xCD,0x58,0x15,0x26,0x4F,0x8D,0xCA,0x8,0x40,0x92,0x80,0x33},
        /*TST_ExternalPublKeySize*/
        40,
        /*TST_ExternalPrivKey*/
        {0x63,0x8D,0x7E,0xAC,0x1A,0x10,0x9D,0x7,0x47,0x8D,0x8C,0xB8,0xE6,0x69,0x8,0x5E,0x94,0x52,0xA0,0x4b},
        /*TST_ExternalPrivlKeySize*/
        20,
		   /*TST_ExternalPublKey*/
        {0x36,0x41,0x4F,0xE7,0xDD,0x87,0x39,0x84,0x30,0x13,0x99,0xF4,0x83,0xD6,0xA1,0x79,0xE0,0xD2,0x2C,0xED,0x6D, 
		 0x2D,0xB,0x5A,0x23,0x81,0x36,0xD5,0xCD,0x58,0x15,0x26,0x4F,0x8D,0xCA,0x8,0x40,0x92,0x80,0x33},
        /*TST_ExternalPublKeySize*/
        40,
        /*TST_ExternalPrivKey*/
        {0x63,0x8D,0x7E,0xAC,0x1A,0x10,0x9D,0x7,0x47,0x8D,0x8C,0xB8,0xE6,0x69,0x8,0x5E,0x94,0x52,0xA0,0x4b},
        /*TST_ExternalPrivlKeySize*/
        20,
      },
		{
		{"Acceptance test - ECC-DH DomainID_secp160r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160r1,
        /*TST_ExternalPublKey*/
        {0x4,0x95,0x4F,0x60,0x20,0x11,0x30,0xF0,0xE3,0x14,0x23,0x88,0x84,0x79,0x53,0x88,0x6C,0x37,0x7A,0x50,0x4C, 
		0x5B,0x2D,0x2A,0xF3,0x85,0xC7,0xF1,0x4B,0xA1,0x6D,0xF3,0xAA,0xFE,0xA,0x11,0x32,0x4D,0x7A,0x6E,0x0},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x27,0x97,0x7D,0xFB,0x77,0x21,0xED,0xBF,0x24,0x33,0x7A,0x7E,0xC4,0x1F,0xF7,0xBD,0xB0,0xA3,0xA1,0xd4},
        /*TST_ExternalPrivlKeySize*/
        20,
         /*TST_ExternalPublKey*/
        {0x4,0x95,0x4F,0x60,0x20,0x11,0x30,0xF0,0xE3,0x14,0x23,0x88,0x84,0x79,0x53,0x88,0x6C,0x37,0x7A,0x50,0x4C, 
		0x5B,0x2D,0x2A,0xF3,0x85,0xC7,0xF1,0x4B,0xA1,0x6D,0xF3,0xAA,0xFE,0xA,0x11,0x32,0x4D,0x7A,0x6E,0x0},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x27,0x97,0x7D,0xFB,0x77,0x21,0xED,0xBF,0x24,0x33,0x7A,0x7E,0xC4,0x1F,0xF7,0xBD,0xB0,0xA3,0xA1,0xd4},
        /*TST_ExternalPrivlKeySize*/
        20,
    }, { 
        {"Acceptance test - ECC-DH DomainID_secp160r2"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160r2,
          /*TST_ExternalPublKey*/
        {0x4,0x52,0xCB,0x7,0xF4,0x84,0xF9,0xAE,0xCE,0x38,0x31,0xCB,0xC8,0xD3,0xF0,0x4E,0xD,0x4E,0x75,0xD2,0x34, 
		0xC5,0xA2,0x83,0x21,0x41,0x5D,0x23,0x79,0x9B,0x1E,0xB2,0xCA,0x7F,0x57,0x45,0x60,0xDC,0xDC,0x70,0x89},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x54,0x66,0x51,0x66,0x4C,0xDC,0xE6,0xC6,0xE4,0xE9,0x56,0x3,0xD3,0x62,0xD0,0x89,0x1A,0x85,0xF1,0x5},
        /*TST_ExternalPrivlKeySize*/
        20,
         /*TST_ExternalPublKey*/
        {0x4,0x52,0xCB,0x7,0xF4,0x84,0xF9,0xAE,0xCE,0x38,0x31,0xCB,0xC8,0xD3,0xF0,0x4E,0xD,0x4E,0x75,0xD2,0x34, 
		0xC5,0xA2,0x83,0x21,0x41,0x5D,0x23,0x79,0x9B,0x1E,0xB2,0xCA,0x7F,0x57,0x45,0x60,0xDC,0xDC,0x70,0x89},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x54,0x66,0x51,0x66,0x4C,0xDC,0xE6,0xC6,0xE4,0xE9,0x56,0x3,0xD3,0x62,0xD0,0x89,0x1A,0x85,0xF1,0x5},
        /*TST_ExternalPrivlKeySize*/
        20,
    }, { 
        {"Acceptance test - ECC-DH DomainID_secp160k1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160k1,
       /*TST_ExternalPublKey*/
        {0x4,0x88,0x5,0x4E,0xA4,0x8,0xDF,0xB,0x5F,0x51,0x5,0x38,0x22,0x4B,0xBA,0x36,0xED,0x53,0x15,0x97,0x5F, 
		0xE0,0xDD,0x3E,0xE9,0xF6,0xDA,0x26,0xD5,0xF2,0xF3,0x19,0xBF,0xF4,0xE1,0x6D,0x93,0xC1,0x1D,0xF,0xa8},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
		{0x8B,0x4B,0xA3,0xCC,0x6,0x57,0xDA,0x99,0x12,0x94,0xF5,0x98,0x85,0x3D,0xC4,0x25,0xD2,0xD1,0xC7,0x3b},
        /*TST_ExternalPrivlKeySize*/
        20,
         /*TST_ExternalPublKey*/
        {0x4,0x88,0x5,0x4E,0xA4,0x8,0xDF,0xB,0x5F,0x51,0x5,0x38,0x22,0x4B,0xBA,0x36,0xED,0x53,0x15,0x97,0x5F, 
		0xE0,0xDD,0x3E,0xE9,0xF6,0xDA,0x26,0xD5,0xF2,0xF3,0x19,0xBF,0xF4,0xE1,0x6D,0x93,0xC1,0x1D,0xF,0xa8},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
		{0x8B,0x4B,0xA3,0xCC,0x6,0x57,0xDA,0x99,0x12,0x94,0xF5,0x98,0x85,0x3D,0xC4,0x25,0xD2,0xD1,0xC7,0x3b},
        /*TST_ExternalPrivlKeySize*/
        20,
    },  
	{ 
        {"Acceptance test - ECC-DH DomainID_secp192r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp192r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0xad,0x41,0x02,0x31,0x0e,0x44,0xee,0x09,0x38,0x33,0xc6,0x98,0x00,0x80,0x55,0xac,
         0xc6,0xb4,0xe8,0xad,0x4c,0xf2,0x63,0xf8,0x09,0x4a,0xd3,0x9c,0x37,0x6c,0xe0,0xc5,
         0xb7,0x1c,0x51,0xc1,0x54,0x8d,0x1d,0x86,0x73,0x93,0x1c,0x83,0xb9,0x80,0x2c,0xe6},
        /*TST_ExternalPublKey1Size*/
        49,
        /*TST_ExternalPrivKey1*/
        {0xec,0x27,0xd0,0x97,0xb3,0x7a,0xe5,0xaf,0xb7,0x9d,0xb8,0xde,0x41,0xa9,0x9f,0xb3,
         0x87,0x28,0xda,0x8b,0x1c,0x99,0xac,0xb6},
        /*TST_ExternalPrivKey1Size*/
        24,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x44,0xaa,0x36,0xa2,0x5b,0xc3,0xdd,0xe6,0x28,0x8a,0x32,0x55,0xc7,0x1a,0x51,0x32,
         0x9e,0x42,0xaa,0x04,0x03,0x54,0x3b,0x10,0x53,0xec,0xef,0x1d,0x5d,0x71,0x43,0x45,
         0x3b,0x86,0xc2,0xf3,0x50,0xb6,0xc3,0xbd,0x4d,0xa7,0x70,0x7f,0x48,0xcc,0x37,0x10},
        /*TST_ExternalPublKey2Size*/
        49,
        /*TST_ExternalPrivKey2*/
        {0xcc,0x61,0x3b,0x0b,0xea,0xc9,0x8e,0x15,0xc8,0x42,0x02,0xd9,0x9f,0xfc,0xf8,0x48,
         0xb9,0x21,0xdb,0x35,0xc0,0xbb,0x5b,0xa2},
        /*TST_ExternalPrivKey2Size*/
        24,
    },
	{ 
        {"Acceptance test - ECC-DH DomainID_secp192k1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp192k1,
         /*TST_ExternalPublKey*/
        {0x4,0x9B,0x3C,0xF6,0xC7,0xDD,0x70,0x6D,0xA9,0xCE,0x4B, 
		0x44,0x56,0xD4,0xAF,0xF1,0x5,0x87,0xEB,0x1C,0xA4,0x3F,0xB5,0xB5,0xCD,0x6A,0x13,0x1B,0xCD,0x18,0x19, 
		0x3E,0x24,0x4D,0x13,0xAC,0xAA,0x40,0xFC,0xA6,0x45,0x58,0x20,0xAD,0xA6,0x6,0x64,0x4F,0x59},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0x17,0x12,0x10,0xB3,0x5B,0xC4,0x6D,0xF,0x3D,0xBA,0x5B,0x69,0x2C,0xAE,0xA6,0x68,0xE9,0xF8,0x20,0x8,0x84,0x26,0x28,0x67},
        /*TST_ExternalPrivlKeySize*/
        24,
         /*TST_ExternalPublKey*/
        {0x4,0x9B,0x3C,0xF6,0xC7,0xDD,0x70,0x6D,0xA9,0xCE,0x4B, 
		0x44,0x56,0xD4,0xAF,0xF1,0x5,0x87,0xEB,0x1C,0xA4,0x3F,0xB5,0xB5,0xCD,0x6A,0x13,0x1B,0xCD,0x18,0x19, 
		0x3E,0x24,0x4D,0x13,0xAC,0xAA,0x40,0xFC,0xA6,0x45,0x58,0x20,0xAD,0xA6,0x6,0x64,0x4F,0x59},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0x17,0x12,0x10,0xB3,0x5B,0xC4,0x6D,0xF,0x3D,0xBA,0x5B,0x69,0x2C,0xAE,0xA6,0x68,0xE9,0xF8,0x20,0x8,0x84,0x26,0x28,0x67},
        /*TST_ExternalPrivlKeySize*/
        24,
    },
    { 
        {"Acceptance test - ECC-DH DomainID_secp224r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp224r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0x52,0x54,0xce,0x14,0x3c,0x02,0x5b,0x14,0x0d,0xd9,0x94,0xfd,0x25,0xaa,0x31,0x36,
         0xe9,0x2f,0x39,0xd0,0x2f,0xe0,0x4f,0x3e,0x45,0x5a,0x1f,0xa2,0xb2,0xda,0xc0,0x26,
         0x0b,0x27,0x45,0xdb,0xcc,0xfd,0x3c,0xb7,0xb6,0xca,0xc7,0x91,0xf2,0x27,0xf6,0xc9,
         0x0c,0xd1,0x1d,0x26,0x29,0x22,0x92,0x2f},
        /*TST_ExternalPublKey1Size*/
        57,
        /*TST_ExternalPrivKey1*/
        {0x81,0x8a,0xd9,0x2a,0x73,0xbb,0xa7,0xe8,0xc3,0xfb,0xb8,0x66,0x8c,0xc1,0xf9,0xc5,
         0xcd,0xf3,0xa8,0x26,0xd7,0x86,0x3d,0x85,0xe5,0xc0,0x86,0x2c},
        /*TST_ExternalPrivKey1Size*/
        28,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x61,0x80,0x7a,0x2c,0x2a,0xb8,0x33,0xf8,0xe5,0x69,0x3a,0x28,0x45,0x61,0x17,0x2e,
         0xec,0x89,0x65,0xb6,0x11,0xb0,0x2a,0xf2,0xfc,0xa1,0xe8,0x35,0x0d,0xbd,0x58,0x3f,
         0x66,0xed,0xec,0xa1,0x80,0x25,0x3f,0xc2,0x5e,0xef,0xa9,0x9c,0xcd,0xeb,0x79,0x40,
         0x23,0x63,0xe3,0x5f,0xaf,0x36,0x3f,0xc6},
        /*TST_ExternalPublKey2Size*/
        57,
        /*TST_ExternalPrivKey2*/
        {0xd5,0xec,0x5d,0xed,0x8f,0xc4,0xdd,0x82,0x74,0x26,0x62,0xcc,0x60,0x68,0x22,0xd0,
        0x1a,0x27,0x57,0x21,0xb8,0xa0,0xcf,0x78,0x0f,0x9c,0xd0,0x36},
        /*TST_ExternalPrivKey2Size*/
        28,
    },
	{ 
        {"Acceptance test - ECC-DH DomainID_secp224k1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp224k1,
        /*TST_ExternalPublKey*/
        {0x4,0xCC,0xCB,0x75,0xC7,0x91,0x5F,0x2B,0x7E,0x81,0xF4,0xB9,0x18,0x10,0x47,0xB2,0x89,0x7,0x9E,0x3B,0x43, 
		0x19,0xE4,0xAB,0x83,0x4D,0x2E,0xDE,0x53,0x12,0xD4,0xC2,0x53,0xEF,0x93,0x1A,0xEC,0xF4,0x94,0x5B,0x1, 
		0x5D,0x90,0x2F,0x5E,0xE2,0x2F,0xAD,0x51,0xA9,0xCE,0x9E,0x98,0x80,0x32,0x18,0x5f},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0x64,0x12,0x78,0x2A,0xF3,0x8F,0xEB,0xEA,0x11,0x81,0xC, 
		0xA4,0xF1,0x6F,0x7D,0x21,0xE6,0x1B,0x7B,0x48,0x8F, 
		0xE0,0x84,0xF9,0x95,0x3B,0x32,0xa},
        /*TST_ExternalPrivlKeySize*/
        28,
        /*TST_ExternalPublKey*/
        {0x4,0xCC,0xCB,0x75,0xC7,0x91,0x5F,0x2B,0x7E,0x81,0xF4,0xB9,0x18,0x10,0x47,0xB2,0x89,0x7,0x9E,0x3B,0x43, 
		0x19,0xE4,0xAB,0x83,0x4D,0x2E,0xDE,0x53,0x12,0xD4,0xC2,0x53,0xEF,0x93,0x1A,0xEC,0xF4,0x94,0x5B,0x1, 
		0x5D,0x90,0x2F,0x5E,0xE2,0x2F,0xAD,0x51,0xA9,0xCE,0x9E,0x98,0x80,0x32,0x18,0x5f},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0x64,0x12,0x78,0x2A,0xF3,0x8F,0xEB,0xEA,0x11,0x81,0xC, 
		0xA4,0xF1,0x6F,0x7D,0x21,0xE6,0x1B,0x7B,0x48,0x8F, 
		0xE0,0x84,0xF9,0x95,0x3B,0x32,0xa},
        /*TST_ExternalPrivlKeySize*/
        28,
    },
    
    { 
        {"Acceptance test - ECC-DH DomainID_secp256r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp256r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0x4e,0x70,0x81,0xa8,0x89,0xb6,0x26,0x9e,0xd6,0xad,0xa9,0xa2,0x5a,0xa4,0x9b,0x9f,
         0x47,0x85,0x01,0x53,0xe3,0x41,0xdb,0xa9,0xa1,0x9f,0xfa,0xbe,0xe0,0xf7,0xe6,0x50,
         0xcb,0x2a,0x00,0x0a,0x54,0x21,0x70,0x4b,0x6c,0xfb,0x79,0xe1,0xe3,0x0f,0xc7,0x23,
         0xf3,0x00,0x4a,0x12,0x7e,0xa8,0x5b,0xb9,0xd1,0x9e,0x46,0x75,0xf7,0x06,0xb0,0x2f},
        /*TST_ExternalPublKey1Size*/
        65,
        /*TST_ExternalPrivKey1*/
        {0x3e,0xa3,0x6f,0x17,0xa6,0x1a,0x2b,0xeb,0xff,0xba,0x58,0x3d,0xb5,0x9a,0x0c,0xd0,
         0x0a,0xff,0x50,0x25,0xab,0xbc,0xdb,0x6b,0x1b,0xe8,0x2c,0xe4,0x51,0xcf,0x3c,0x9b},
        /*TST_ExternalPrivKey1Size*/
        32,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x09,0x59,0x82,0xfc,0x5f,0xa8,0x2a,0x0d,0x19,0x3e,0x64,0x72,0x61,0x8d,0x9a,0x78,
         0x45,0x44,0x7f,0xdc,0x72,0x19,0xca,0x5f,0x0a,0x6b,0xfd,0x60,0xb2,0x10,0x2d,0xd8,
         0x5a,0x3a,0x0c,0xdb,0xb3,0xf1,0x2b,0xf2,0x40,0x5c,0xa4,0x3c,0x00,0xdf,0xc5,0x8a,
         0xa6,0x80,0x60,0x73,0x0b,0xee,0xe7,0x73,0xeb,0x79,0xd5,0x16,0xbb,0xc0,0x61,0x6c},
        /*TST_ExternalPublKey2Size*/
        65,
        /*TST_ExternalPrivKey2*/
        {0x53,0x98,0xdb,0xf1,0x28,0xce,0xc4,0xb3,0x79,0x9b,0x56,0x17,0xa8,0xac,0xf2,0x76,
         0x83,0x66,0xf9,0x21,0x15,0x2f,0x4b,0x4d,0xb2,0x5b,0x1d,0x24,0xcc,0x37,0xde,0x13},
        /*TST_ExternalPrivKey2Size*/
        32,
    },
	 { 
        {"Acceptance test - ECC-DH DomainID_secp256k1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp256k1,
        /*TST_ExternalPublKey*/
        {0x4,0xBF,0xC2,0x4C,0xCD,0x8B,0x2E,0x52,0x10,0x36,0x64,0x85,0x3,0x66,0x98,0x2B,0xC4,0x47,0xEC,0x49,0x68, 
		0x4C,0x26,0xB9,0x20,0xF6,0xB,0x20,0xE2,0xF4,0xF2,0x4B,0x7F,0x28,0x5D,0x74,0x81,0xA3,0xD1,0x6B,0x16, 
		0x87,0xF3,0xEE,0x21,0x90,0xF,0x3C,0x96,0xE0,0x53,0x21,0x83,0x94,0x0,0xE8,0x96,0x45,0x4F,0x47,0xF4,0xD8,0xA1,0xD9,0xae},
        /*TST_ExternalPublKeySize*/
        65,
        /*TST_ExternalPrivKey*/
        {0xB5,0xCD,0x5E,0xB3,0x93,0xA5,0xB8,0x69,0xDE,0xCA,0xF8,0x8D,0x56,0x20,0x85,0xB1,0x7E,0xED,0x74,0xB1,0x94, 
		 0x79,0x16,0xDA,0x93,0xFE,0x82,0x53,0x90,0x4,0x93,0xa7},
        /*TST_ExternalPrivlKeySize*/
        32,
        /*TST_ExternalPublKey*/
        {0x4,0xBF,0xC2,0x4C,0xCD,0x8B,0x2E,0x52,0x10,0x36,0x64,0x85,0x3,0x66,0x98,0x2B,0xC4,0x47,0xEC,0x49,0x68, 
		0x4C,0x26,0xB9,0x20,0xF6,0xB,0x20,0xE2,0xF4,0xF2,0x4B,0x7F,0x28,0x5D,0x74,0x81,0xA3,0xD1,0x6B,0x16, 
		0x87,0xF3,0xEE,0x21,0x90,0xF,0x3C,0x96,0xE0,0x53,0x21,0x83,0x94,0x0,0xE8,0x96,0x45,0x4F,0x47,0xF4,0xD8,0xA1,0xD9,0xae},
        /*TST_ExternalPublKeySize*/
        65,
        /*TST_ExternalPrivKey*/
        {0xB5,0xCD,0x5E,0xB3,0x93,0xA5,0xB8,0x69,0xDE,0xCA,0xF8,0x8D,0x56,0x20,0x85,0xB1,0x7E,0xED,0x74,0xB1,0x94, 
		 0x79,0x16,0xDA,0x93,0xFE,0x82,0x53,0x90,0x4,0x93,0xa7},
        /*TST_ExternalPrivlKeySize*/
        32,
    },
    { 
        {"Acceptance test - ECC-DH DomainID_secp384r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp384r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0x86,0xd0,0x39,0xe9,0xaa,0xa6,0x81,0xf1,0xfe,0x0a,0xf2,0x85,0x74,0x93,0x3a,0xd9,
         0xb6,0x6a,0xe2,0x16,0xa2,0xc6,0x00,0xe4,0x10,0xec,0x0b,0xb9,0xa0,0x0f,0xe9,0x48,
         0xe1,0x89,0x55,0x04,0x5c,0x4f,0xa4,0xd4,0x3f,0xb3,0xa8,0xeb,0xc8,0xc2,0x3a,0xa4,
         0x09,0x30,0xae,0xe5,0x06,0xae,0x36,0x19,0x5f,0x40,0xe1,0x2e,0x0c,0x53,0x3b,0x6c,
         0xa6,0x2c,0x3f,0xb0,0x11,0x7a,0x33,0x66,0xd0,0xcc,0x22,0xaa,0xf1,0x4d,0x27,0x04,
         0x70,0xa7,0x2c,0x91,0xfe,0xcc,0x9b,0x9b,0xda,0xa8,0xa2,0xbc,0xd8,0x7a,0x98,0x31},
        /*TST_ExternalPublKey1Size*/
        97,
        /*TST_ExternalPrivKey1*/
        {0x08,0xb7,0x3a,0x32,0x62,0xe9,0x44,0x01,0x6a,0xe3,0x2e,0xa2,0xc6,0xf7,0x82,0x60,
         0x18,0xf9,0xc7,0xcc,0xb8,0x5b,0x06,0xde,0x9e,0x19,0x21,0xbe,0x0a,0xf7,0x4b,0x28,
         0x9f,0x01,0x19,0x89,0xef,0xd8,0x2c,0x08,0x78,0x4c,0x3e,0x4b,0x14,0xae,0x61,0x27},
        /*TST_ExternalPrivKey1Size*/
        48,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x60,0xc1,0x41,0x29,0x74,0x67,0x24,0x67,0x2c,0x06,0x4e,0x0d,0x17,0x99,0x67,0x7c,
         0xf3,0x37,0x6d,0x00,0x78,0x91,0x4f,0xce,0xf4,0xab,0x81,0xac,0x67,0x6f,0x63,0x45,
         0x38,0x1a,0x7d,0xa6,0xa3,0xeb,0xcd,0x7e,0x77,0xef,0x8f,0x8f,0xf6,0xc3,0x6f,0x3d,
         0x42,0x92,0x88,0x75,0xb9,0xe0,0x8c,0x4e,0xec,0x04,0x6d,0x1e,0xde,0x45,0x43,0x0f,
         0x4c,0xaf,0x84,0xfe,0xfc,0x97,0x68,0xfa,0x18,0xbf,0x93,0x0d,0xa6,0xb1,0xbf,0x74,
         0x4e,0xc3,0x3e,0xb2,0x96,0x67,0x20,0xb8,0x55,0x3f,0x95,0x3f,0x52,0xb9,0x32,0x18},
        /*TST_ExternalPublKey2Size*/
        97,
        /*TST_ExternalPrivKey2*/
        {0x95,0x57,0xb8,0x78,0x2d,0xc7,0x77,0xf3,0xff,0x78,0x5b,0x9f,0xff,0xe4,0x20,0x77,
         0x55,0xd0,0xdc,0x4b,0xb2,0xce,0x37,0xb8,0x01,0x4a,0x02,0xea,0x13,0xa6,0xf9,0x88,
         0x74,0xe5,0xa3,0xf5,0xf7,0xd7,0xf0,0xf1,0xa6,0x44,0xb2,0x21,0x10,0x06,0xfc,0xfc},
        /*TST_ExternalPrivKey2Size*/
        48,
	  },

    { 
        {"Acceptance test - ECC-DH DomainID_secp521r1"},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp521r1,
        /*TST_ExternalPublKey1*/
        {0x04,
         0x01,0x97,0xb8,0x6b,0x1b,0x7d,0xa3,0xb9,0x44,0x51,0xa2,0xfc,0x6c,0x77,0xae,0x65,
         0x24,0xfd,0x3d,0xdb,0xa9,0x43,0x4f,0x79,0x66,0x5a,0xb1,0x4c,0x8e,0xa9,0xb3,0x88,
         0x6f,0xf3,0x5a,0x96,0xb4,0x92,0xb4,0xa2,0x06,0xbf,0x19,0x52,0x87,0x7a,0xff,0xff,
         0x31,0xe3,0x4e,0x10,0x2b,0x19,0x35,0x16,0x28,0xb6,0xd5,0x19,0xc9,0x7c,0x3d,0xf8,
         0x86,0x22,0x00,0x5e,0x40,0x8b,0x7c,0xe0,0xc3,0x26,0xea,0x94,0x2b,0xbe,0x79,0xe6,0x22,
         0x1e,0x9a,0x5b,0x62,0x97,0xc6,0xa2,0x69,0xab,0xd1,0x1e,0xe3,0xd2,0xc2,0x4e,0x4a,
         0x1a,0xc3,0xa3,0x74,0x12,0x0f,0x5c,0x32,0x05,0xae,0x10,0x6a,0xb7,0xe2,0x76,0x09,
         0xdd,0x69,0xd0,0x99,0xd7,0x2f,0x85,0xd5,0x9f,0x41,0x31,0x1c,0xa2,0x70,0x3a,0xa8,
         0x21,0xa7,0x6a},
        /*TST_ExternalPublKey1Size*/
        133,
        /*TST_ExternalPrivKey1*/
        {0x49,0xe4,0xed,0x27,0xdc,0x7a,0x6c,0x55,0xa3,0xb5,0xc4,0x12,0x51,0xdb,0x4d,0x21,
         0xd8,0x7d,0x69,0x6e,0xc6,0xc3,0xd4,0x2a,0xfc,0xf6,0xc8,0x1f,0xbe,0x46,0x99,0x2d,
         0x91,0x37,0x7b,0x7e,0xef,0x25,0x28,0xf4,0x35,0x84,0x9e,0xfb,0x7b,0x0e,0x44,0x0d,
         0x52,0x9b,0x8b,0x2f,0x9f,0xc5,0x01,0x40,0xc3,0xf6,0x2f,0x8b,0xa8,0x64,0xfa,0x47,
         0x0e},
        /*TST_ExternalPrivKey1Size*/
        65,
        /*TST_ExternalPublKey2*/
        {0x04,
         0x00,0xee,0x77,0xf4,0x37,0x72,0x1e,0x0d,0xf3,0x5d,0x20,0xb1,0xe5,0xbe,0xb9,0x1f,
         0x86,0xb1,0x82,0x93,0x20,0x20,0x2d,0x5d,0x6a,0x7b,0x7a,0x36,0x19,0xe8,0xf3,0xba,
         0x30,0xc8,0x45,0x76,0x03,0xf7,0xa0,0xa9,0x26,0x36,0x85,0x9c,0x0f,0xee,0x99,0xfb,
         0x32,0xbc,0xdd,0x13,0xf5,0xdc,0x53,0xa9,0x16,0x81,0x69,0xff,0x9c,0xc4,0x39,0x79,
         0xd2,0x19,0x00,0x4f,0xce,0x2f,0xd3,0x4f,0xf5,0x08,0x92,0x5a,0x95,0x15,0x9a,0x57,0x35,
         0x54,0x96,0x50,0xc5,0xcd,0x79,0xcd,0x3c,0x7d,0x6b,0x38,0x8c,0x66,0x66,0x82,0x3a,
         0xb2,0xdb,0xb6,0xa5,0x87,0x29,0x4a,0x78,0xaa,0x92,0x30,0x1e,0x8c,0x72,0x7a,0xab,
         0xc1,0x6e,0xad,0x24,0x38,0x5c,0x1c,0xda,0x6e,0x82,0x8a,0x59,0x13,0x84,0xb4,0xe4,
         0xbe,0xa5,0x37},
        /*TST_ExternalPublKey2Size*/
        133,
        /*TST_ExternalPrivKey2*/
        {0x2e,0x22,0x9b,0x00,0xdd,0x11,0x7b,0x07,0x75,0xc0,0x86,0xa9,0xe2,0xa2,0x04,0xb4,
         0x31,0x14,0x22,0x2c,0x70,0xf3,0x7e,0xed,0x18,0xd4,0xc0,0xe6,0xde,0x60,0x3f,0xbc,
         0xba,0xdb,0x49,0x1c,0xc7,0x01,0x87,0x46,0x33,0xa0,0x9a,0x31,0x4a,0x11,0xfd,0xb6,
         0x87,0x6d,0x97,0x5c,0x23,0xea,0xbf,0xc4,0xe7,0xf7,0x13,0x98,0xb7,0xd5,0x56,0xc5,
         0x74},
        /*TST_ExternalPrivKey2Size*/
        65,
    },
	
};
/***************************************/
/*  ElGamal Encrypt Decrypt test data  */
/***************************************/
#if !(TST_USE_ECC_23BYTE_DATA|TST_USE_ECC_27BYTE_DATA|TST_USE_ECC_31BYTE_DATA|TST_USE_ECC_47BYTE_DATA|TST_USE_ECC_64BYTE_DATA)
TST_ECC_EncDecTestDataStruct TST_ECC_Acceptance_ElGamal_EncDec_TestData[] = {0};
#else
TST_ECC_EncDecTestDataStruct TST_ECC_Acceptance_ElGamal_EncDec_TestData[] =
{
    #if TST_USE_ECC_23BYTE_DATA
	{ 
       {"Acceptance test - ElGamal EncryptDecrypt WMDRM-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_WMDRM10,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
		0xe3,0xd9,0x85},
        /*TST_input_dataSize*/
        19, 
         /*TST_ExternalPublKey*/
        {0x36,0x41,0x4F,0xE7,0xDD,0x87,0x39,0x84,0x30,0x13,0x99,0xF4,0x83,0xD6,0xA1,0x79,0xE0,0xD2,0x2C,0xED,0x6D, 
		0x2D,0xB,0x5A,0x23,0x81,0x36,0xD5,0xCD,0x58,0x15,0x26,0x4F,0x8D,0xCA,0x8,0x40,0x92,0x80,0x33},
        /*TST_ExternalPublKeySize*/
        40,
        /*TST_ExternalPrivKey*/
        {0x63,0x8D,0x7E,0xAC,0x1A,0x10,0x9D,0x7,0x47,0x8D,0x8C,0xB8,0xE6,0x69,0x8,0x5E,0x94,0x52,0xA0,0x4b},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        19,
	  },
	  { 
       {"Acceptance test - ElGamal EncryptDecrypt secp160r1-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160r1,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3},
        /*TST_input_dataSize*/
        16, 
         /*TST_ExternalPublKey*/
        {0x4,0x95,0x4F,0x60,0x20,0x11,0x30,0xF0,0xE3,0x14,0x23,0x88,0x84,0x79,0x53,0x88,0x6C,0x37,0x7A,0x50,0x4C, 
		0x5B,0x2D,0x2A,0xF3,0x85,0xC7,0xF1,0x4B,0xA1,0x6D,0xF3,0xAA,0xFE,0xA,0x11,0x32,0x4D,0x7A,0x6E,0x0},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x27,0x97,0x7D,0xFB,0x77,0x21,0xED,0xBF,0x24,0x33,0x7A,0x7E,0xC4,0x1F,0xF7,0xBD,0xB0,0xA3,0xA1,0xd4},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        16,
	  },
	
	  { 
        {"Acceptance test - ElGamal EncryptDecrypt secp160r2-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160r2,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
		0xe3,0xd9,0x85},
        /*TST_input_dataSize*/
        19, 
        /*TST_ExternalPublKey*/
        {0x4,0x52,0xCB,0x7,0xF4,0x84,0xF9,0xAE,0xCE,0x38,0x31,0xCB,0xC8,0xD3,0xF0,0x4E,0xD,0x4E,0x75,0xD2,0x34, 
		0xC5,0xA2,0x83,0x21,0x41,0x5D,0x23,0x79,0x9B,0x1E,0xB2,0xCA,0x7F,0x57,0x45,0x60,0xDC,0xDC,0x70,0x89},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
        {0x54,0x66,0x51,0x66,0x4C,0xDC,0xE6,0xC6,0xE4,0xE9,0x56,0x3,0xD3,0x62,0xD0,0x89,0x1A,0x85,0xF1,0x5},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        19,/*23*/
	  },
      { 
        {"Acceptance test - ElGamal EncryptDecrypt secp160k1-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp160k1,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
		0xe3,0xd9},
        /*TST_input_dataSize*/
        18, 
         /*TST_ExternalPublKey*/
        {0x4,0x88,0x5,0x4E,0xA4,0x8,0xDF,0xB,0x5F,0x51,0x5,0x38,0x22,0x4B,0xBA,0x36,0xED,0x53,0x15,0x97,0x5F, 
		0xE0,0xDD,0x3E,0xE9,0xF6,0xDA,0x26,0xD5,0xF2,0xF3,0x19,0xBF,0xF4,0xE1,0x6D,0x93,0xC1,0x1D,0xF,0xa8},
        /*TST_ExternalPublKeySize*/
        41,
        /*TST_ExternalPrivKey*/
		{0x8B,0x4B,0xA3,0xCC,0x6,0x57,0xDA,0x99,0x12,0x94,0xF5,0x98,0x85,0x3D,0xC4,0x25,0xD2,0xD1,0xC7,0x3b},
        /*TST_ExternalPrivlKeySize*/
        20,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        18,
	},
 	{ 
        {"Acceptance test - ElGamal EncryptDecrypt secp192r1-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp192r1,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
         0xe3,0xd9,0x85,0xc6,0x65,0xd7,0x43},
        /*TST_input_dataSize*/
        23, 
        /*TST_ExternalPublKey*/
        {0x04,
         0xb8,0x13,0x76,0x81,0x0d,0x91,0xe6,0x0b,0xe7,0x4e,0x52,0xf6,0x67,0x3d,0x0d,
         0x21,0x38,0x9a,0x12,0xae,0x08,0x40,0xae,0x38,0x0e,0x6d,0xf9,0xda,0xe8,0xae,0xcd,
         0x4b,0x90,0x3e,0xd5,0xfd,0x8f,0xb7,0x37,0x80,0xdb,0xfe,0x90,0x97,0x03,0x48,0x77,
         0x7d},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
         0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d},
        /*TST_ExternalPrivKeySize*/
        24,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        23,/*23*/
    },
	{ 
        {"Acceptance test - ElGamal EncryptDecrypt secp192k1-Key - 23byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp192k1,
        /*TST_input_data*/
        {0xec,0xca,0x8d,0x21,0xfa,0x20,0x4d,0xdc,0x1b,0x04,0x07,0xb9,0xa6,0x46,0xdd,0xa3,
         0xe3,0xd9,0x85,0xc6,0x65},
        /*TST_input_dataSize*/
        21, 
        /*TST_ExternalPublKey*/
        {0x4,0x9B,0x3C,0xF6,0xC7,0xDD,0x70,0x6D,0xA9,0xCE,0x4B, 
		0x44,0x56,0xD4,0xAF,0xF1,0x5,0x87,0xEB,0x1C,0xA4,0x3F,0xB5,0xB5,0xCD,0x6A,0x13,0x1B,0xCD,0x18,0x19, 
		0x3E,0x24,0x4D,0x13,0xAC,0xAA,0x40,0xFC,0xA6,0x45,0x58,0x20,0xAD,0xA6,0x6,0x64,0x4F,0x59},
        /*TST_ExternalPublKeySize*/
        49,
        /*TST_ExternalPrivKey*/
        {0x17,0x12,0x10,0xB3,0x5B,0xC4,0x6D,0xF,0x3D,0xBA,0x5B,0x69,0x2C,0xAE,0xA6,0x68,0xE9,0xF8,0x20,0x8,0x84,0x26,0x28,0x67},
        /*TST_ExternalPrivlKeySize*/
        24,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        96,
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        21,
    },
    #endif
    #if TST_USE_ECC_27BYTE_DATA
    { 
        {"Acceptance test - ElGamal EncryptDecrypt secp224r1-Key - 27byte data  "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp224r1,
        /*TST_input_data*/
        {0x76,0xb1,0xe8,0xfd,0x42,0xd6,0x22,0x96,0xe4,0xea,0x3d,0x84,0x9c,0x7a,0x9f,0x67,
        0x1a,0xca,0x8c,0x3f,0xef,0x78,0x40,0x2e,0x42,0x5d,0x3b},
        /*TST_input_dataSize*/
        27, 
        /*TST_ExternalPublKey*/
        {0x04,
         0xa1,0x62,0x6a,0x86,0x23,0xe1,0x64,0xc6,0x69,0x3d,0x2c,0xee,0xf2,0x8d,0x7a,
         0xa9,0xca,0x25,0xdd,0xf4,0xde,0x94,0xd8,0x9c,0x6f,0x95,0x45,0x2b,0x97,0x52,
         0xe2,0x1d,0x4a,0x73,0xc6,0x01,0x5a,0xd0,0xd4,0x40,0x9c,0x0d,0x77,0xcf,0x2f,
         0xc3,0x24,0xa5,0xac,0x40,0xa0,0xa5,0x1c,0x52,0x9a,0x46},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
         0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65},
        /*TST_ExternalPrivKeySize*/
        28,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        112, 
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        27,/*27*/ 
    },
    { 
        {"Acceptance test - ElGamal EncryptDecrypt secp224k1-Key - 27byte data  "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp224k1,
        /*TST_input_data*/
        {0x76,0xb1,0xe8,0xfd,0x42,0xd6,0x22,0x96,0xe4,0xea,0x3d,0x84,0x9c,0x7a,0x9f,0x67,
        0x1a,0xca,0x8c,0x3f,0xef,0x78,0x40,0x2e},
        /*TST_input_dataSize*/
        24, 
        /*TST_ExternalPublKey*/
        {0x4,0xCC,0xCB,0x75,0xC7,0x91,0x5F,0x2B,0x7E,0x81,0xF4,0xB9,0x18,0x10,0x47,0xB2,0x89,0x7,0x9E,0x3B,0x43, 
		0x19,0xE4,0xAB,0x83,0x4D,0x2E,0xDE,0x53,0x12,0xD4,0xC2,0x53,0xEF,0x93,0x1A,0xEC,0xF4,0x94,0x5B,0x1, 
		0x5D,0x90,0x2F,0x5E,0xE2,0x2F,0xAD,0x51,0xA9,0xCE,0x9E,0x98,0x80,0x32,0x18,0x5f},
        /*TST_ExternalPublKeySize*/
        57,
        /*TST_ExternalPrivKey*/
        {0x64,0x12,0x78,0x2A,0xF3,0x8F,0xEB,0xEA,0x11,0x81,0xC, 
		0xA4,0xF1,0x6F,0x7D,0x21,0xE6,0x1B,0x7B,0x48,0x8F, 
		0xE0,0x84,0xF9,0x95,0x3B,0x32,0xa},
        /*TST_ExternalPrivlKeySize*/
        28,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        112, 
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        24,
    },
    #endif
    #if TST_USE_ECC_31BYTE_DATA
	{ 
        {"Acceptance test - ElGamal EncryptDecrypt secp256r1-Key - 31byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp256r1,
        /*TST_input_data*/
        {0xa1,0xd1,0x45,0xcf,0xac,0x15,0x8b,0x04,0x3b,0x26,0x62,0xa8,0x17,0x78,0xf7,0x81,
        0x01,0x9a,0x34,0x26,0x46,0x74,0xee,0x61,0x93,0xcd,0x60,0xd8,0x0b,0x10,0xd8},
        /*TST_input_dataSize*/
        31, 
        /*TST_ExternalPublKey*/
        {0x04,
         0x2a,0xe4,0xa3,0xca,0x17,0x5e,0x29,0x90,0xfa,0x1e,0x8b,0x67,0x7d,0x33,0x6b,0x4c,
         0xbc,0xe2,0xd8,0x53,0xd7,0x0f,0x37,0x81,0x86,0xe4,0x5b,0x39,0x0b,0x52,0x3d,0xa7,
         0x09,0xaf,0x5b,0xa5,0x62,0x5e,0x73,0xed,0x88,0x3b,0xe1,0xe7,0xac,0x48,0x30,0x06,
         0xa7,0x0f,0x66,0xad,0xf3,0x1f,0xbb,0xe5,0x89,0x1b,0x4b,0x0d,0xa4,0x6c,0xaa,0x07},
        /*TST_ExternalPublKeySize*/
        65,
        /*TST_ExternalPrivKey*/
        {0xf0,0xac,0xa4,0x26,0x28,0x52,0x83,0xa6,0x8c,0xc3,0x4f,0xe7,0xd8,0x62,0xc6,
         0x2a,0xcb,0x33,0xd1,0x4c,0x34,0x0a,0x7d,0xb9,0xa8,0x9b,0x4d,0x6f,0xa0,0xfa,0xb6,
         0x38},
        /*TST_ExternalPrivKeySize*/
        32,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        128, /*48*/
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        31,/*31*/ 
    },
     { 
     {"Acceptance test - ElGamal EncryptDecrypt secp256k1-Key - 31byte data "},
         /*TST_CRYS_ECPKI_DomainID*/
         CRYS_ECPKI_DomainID_secp256k1,
         /*TST_input_data*/
     {0xa1,0xd1,0x45,0xcf,0xac,0x15,0x8b,0x04,0x3b,0x26,0x62,0xa8,0x17,0x78,0xf7,0x81,
     0x01,0x9a,0x34,0x26,0x46,0x74,0xee,0x61,0x93,0xcd,0x60,0xd8,0x0b,0x10},
     /*TST_input_dataSize*/
     30, 
     /*TST_ExternalPublKey*/
     {0x04,0x79,0xBD,0xD7,0x9A,0x85,0xA6,0xC1,0x2D,0x44,0x8E,0xEF,0xDD,0x54,0x8D,0x56,
      0xB1,0xF8,0x7F,0xBF,0xE4,0xF7,0x4D,0xFC,0x38,0x9E,0xEB,0x4A,0xBD,0xE8,0x00,0x06,
      0x69,0x23,0xDB,0x71,0xD2,0xF7,0x04,0x70,0x32,0x6E,0xAF,0x39,0xD7,0x53,0x7A,0xB4,
      0x72,0xC3,0x10,0x01,0x88,0x68,0xE,0xA4,0xD9,0x5F,0xBF,0x04,0x33,0x6B,0x20,0x1D,0xe7},
     /*TST_ExternalPublKeySize*/
     65,
     /*TST_ExternalPrivKey*/
     {0x84,0x44,0x68,0xAA,0x34,0x69,0xA8,0xA6,0xC9,0xF4, 0xF3,0xBF,0x32,0xFF,0x16,0xCA
      ,0xD8,0xB8,0xF3,0xA3,0xE4,0xF3,0xA2,0x63,0xBE,0x87,0xE3,0x8C,0xE1,0x18,0xD1,0x76},
     /*TST_ExternalPrivKeySize*/
     32,
     /*TST_output_data*/
     {0x2b,0x90,0xaa,0x1d,0xeb,0x67,0x0d,0x8c,0xb6,0xd5,0xbb,0x2c,0xb3,0xca,0xed,0x9a,
     0x50,0xfc,0x12,0x3b,0x57,0x31,0xde,0x57,0xfc,0x53,0x26,0xac,0x3a,0xe2,0x47,0x29,
     0x11,0x11,0xa6,0x85,0x39,0x21,0x6b,0x7d,0x4e,0x1d,0x68,0xae,0x67,0x17,0xc2,0x15,
     0x42,0x6c,0x27,0xcf,0xaa,0xd1,0x0e,0xdd,0x32,0x3d,0x06,0x39,0xaa,0xf7,0x65,0x9e,
     0x10,0x6f,0xc9,0xbf,0xdc,0x8c,0x89,0x2f,0x49,0xc7,0x81,0xdf,0x8d,0x81,0x75,0xb9,
     0x40,0x1d,0x8f,0x0a,0x2f,0x5c,0x80,0x96,0xd8,0x5d,0x18,0x0b,0x30,0x41,0x28,0xea,
     0xa3,0x23,0x60,0x3b,0xfe,0xb3,0x6d,0x49,0xde,0x64,0xf7,0xc4,0x92,0x03,0x25,0x7a,
     0xa5,0xcf,0xf9,0x1c,0x6c,0x51,0xd5,0x1f,0x65,0x26,0x84,0x3f},
     /*TST_output_dataSize*/
     128,
     /*TST_Decrypted_data*/
     {0},
     /*TST_output_dataSize*/
     30,
     },
     #endif
    #if TST_USE_ECC_47BYTE_DATA
    { 
        {"Acceptance test - ElGamal EncryptDecrypt secp384r-Key - 47byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp384r1,
        /*TST_input_data*/
        {0x88,0xd9,0xa3,0x41,0xe7,0x27,0xbb,0x33,0x9f,0x8e,0x18,0xa3,0xfa,0xc2,0xf2,0xfb,
         0x85,0xab,0xdc,0x8f,0x13,0x5d,0xeb,0x30,0x05,0x4a,0x1a,0xfd,0xc9,0xb6,0xed,0x7d,
         0xa1,0x6c,0x55,0xeb,0xa6,0xb0,0xd4,0xd1,0x0c,0x74,0xe1,0xd9,0xa7,0xcf,0x8e},
        /*TST_input_dataSize*/
        47, 
        /*TST_ExternalPublKey*/
        {0x04,
         0xd1,0x30,0x07,0x87,0x84,0x4c,0x85,0x27,0xfa,0x2d,0xf3,0xfd,0x7f,0x51,0x4f,0xa9,
         0xf5,0x6b,0x78,0xfe,0x93,0x5c,0x68,0x7c,0x9e,0x7c,0xe1,0xbc,0xa7,0x95,0xb9,0xeb,
         0xc5,0x14,0x77,0x1b,0x65,0x30,0x18,0x27,0xbd,0x27,0x5e,0x7c,0xcc,0xe0,0x59,0xf4,
         0x62,0x3b,0x1a,0x20,0xe0,0x05,0x1e,0xe6,0x77,0x63,0x97,0x76,0xd0,0x86,0xb1,0x74,
         0xa2,0x57,0x45,0x4c,0xa5,0xef,0xab,0xf7,0xca,0xb9,0x9f,0xdb,0x33,0x66,0x28,0xb2,
         0x04,0x7f,0x16,0x0a,0x59,0xb8,0x41,0x05,0x2e,0x3f,0x78,0x7b,0xfd,0x50,0x46,0x30},
        /*TST_ExternalPublKeySize*/
        97,
        /*TST_ExternalPrivKey*/
        {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,0x5d,
         0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65,0x81,0xbe,0xa1,0xf3,
         0x12,0x8e,0xdd,0xe9,0xaa,0xd2,0xd3,0x86,0x6b,0x26,0xc3,0x3d,0x72,0x12,0x52,0xc2},         
        /*TST_ExternalPrivKeySize*/
        48,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        192, /*48*/
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        47,/*47*/
    },
    #endif
    #if TST_USE_ECC_64BYTE_DATA
	{ 
        {"Acceptance test - ElGamal EncryptDecrypt secp521r-Key - 64byte data "},
        /*TST_CRYS_ECPKI_DomainID*/
        CRYS_ECPKI_DomainID_secp521r1,
        /*TST_input_data*/
        {0x1d,0xa0,0x02,0x4c,0x89,0x35,0xff,0x67,0x4b,0xfb,0xc8,0xf8,0x12,0x76,0x24,0xbd,
         0x75,0x73,0xfa,0x11,0x35,0x3e,0xb7,0xbf,0xc2,0x16,0xf0,0x14,0x01,0xde,0x49,0x38,
         0x4d,0x15,0x95,0xbe,0xbc,0x08,0x3e,0x79,0xa3,0x46,0xe7,0x91,0x5c,0x55,0x51,0xd7,
		 0x46,0xa3,0x7b,0x56,0x0e,0xbf,0x0e,0x2a,0x2d,0xc9,0xf7,0x96,0xb2,0x28,0x56,0x50},
         //0x11},
        /*TST_input_dataSize*/
        64, 
        /*TST_ExternalPublKey*/
        {0x04,
         0x00,0x46,0xe3,0x1d,0x63,0x0c,0xe3,0x98,0xa7,0xfd,0x03,0xc9,0x4f,0x61,0x77,0xbe,
         0x37,0x85,0x94,0x0f,0x73,0x4a,0xf1,0x62,0x13,0x46,0x58,0x15,0x4a,0x4a,0xf5,0x49,
         0x8c,0x2a,0x24,0x53,0xc4,0xda,0x1a,0xe3,0x15,0x10,0x86,0x07,0xc3,0xd8,0xd3,0xde,
         0x5b,0xdb,0x83,0xf5,0x0e,0x3f,0x29,0x77,0x2c,0x7c,0x80,0x3d,0x4d,0x7c,0x1d,0x9f,
         0xdc,0x2a,0x01,0x17,0x39,0x9d,0xb3,0x7a,0x4a,0x41,0x10,0xfb,0x45,0x2a,0x67,0xbc,
         0x0c,0x6f,0x84,0x41,0xcd,0x52,0xf3,0xae,0x46,0xaa,0x69,0x14,0x94,0xc4,0xa8,0x19,
         0x20,0xc3,0x5b,0xe9,0x84,0x67,0x5f,0x0e,0xde,0x40,0xe5,0x74,0x4d,0x7a,0x68,0xfb,
         0x6d,0xf7,0x49,0x4a,0xf6,0xed,0xd0,0x2b,0x5c,0x28,0x1b,0x34,0xd9,0x5f,0x5b,0xbe,
         0xa5,0x84,0x59,0xcf},
        /*TST_ExternalPublKeySize*/
        133,
        /*TST_ExternalPrivKey*/
        {0xd8,0xc1,0x73,0x2c,0x26,0x96,0x33,0xe0,0xbe,0x2d,0x26,0x60,0x82,0x16,0x80,
         0x5d,0x94,0x9c,0xed,0x04,0x9f,0xf5,0x8f,0x5d,0xbf,0x7d,0x8c,0x65,0x81,0xbe,0xa1,
         0xf3,0x12,0x8e,0xdd,0xe9,0xaa,0xd2,0xd3,0x86,0x6b,0x26,0xc3,0x3d,0x72,0x12,0x52,
         0xc2,0x1d,0xba,0x3f,0x98,0x73,0xd6,0xbc,0x69,0x37,0x50,0x39,0x80,0x4f,0x57,0xb1,
         0xe4,0xa4},
        /*TST_ExternalPrivKeySize*/
        65,
        /*TST_output_data*/
        {0},
        /*TST_output_dataSize*/
        512, /* 64 */
		
        /*TST_Decrypted_data*/
        {0},
        /*TST_output_dataSize*/
        64,
    },
    #endif
};
#endif

const int TST_NumberOf_ECC_SignVerifyAcceptanceTests = sizeof(TST_ECC_Acceptance_ECDSA_SignVerify_TestData)/sizeof(TST_ECC_Acceptance_ECDSA_SignVerify_TestData[0]);
const int TST_NumberOf_ECC_DHAcceptanceTests = sizeof(TST_ECC_Acceptance_DH_TestData)/sizeof(TST_ECC_Acceptance_DH_TestData[0]);
const int TST_NumberOf_ECC_ElGamalAcceptanceTests = sizeof(TST_ECC_Acceptance_ElGamal_EncDec_TestData)/sizeof(TST_ECC_Acceptance_ElGamal_EncDec_TestData[0]);

#endif

